function varargout = EKG(varargin)
% EKG M-file for EKG.fig
%      EKG, by itself, creates a new EKG or raises the existing
%      singleton*.
%
%      H = EKG returns the handle to a new EKG or the handle to
%      the existing singleton*.
%
%      EKG('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in EKG.M with the given input arguments.
%
%      EKG('Property','Value',...) creates a new EKG or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before EKG_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to EKG_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help EKG

% Last Modified by GUIDE v2.5 19-Jan-2004 11:58:59

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @EKG_OpeningFcn, ...
                   'gui_OutputFcn',  @EKG_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin & isstr(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before EKG is made visible.
function EKG_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to EKG (see VARARGIN)

% Choose default command line output for EKG
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes EKG wait for user response (see UIRESUME)
% uiwait(handles.figure1);

% Set the background color for the application window
set(gcf,'Color',[0 0 0.251])

% --- Outputs from this function are returned to the command line.
function varargout = EKG_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes during object creation, after setting all properties.
function end_t_CreateFcn(hObject, eventdata, handles)
% hObject    handle to end_t (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


function end_t_Callback(hObject, eventdata, handles)
% hObject    handle to end_t (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% the Callback function for the timeplot push button to perform the time
% series graph of the signal

function timeplot_Callback(hObject, eventdata, handles)
% hObject    handle to timeplot (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Read the filename from the file_input edit box

filename = get(handles.file_input, 'String');

% the file data are assigned to the variable H, an nx2 array

H = xlsread(filename);

% an array D is generated containing the elements
% of the second column of H (i.e. the data values)

D = H(:,2);

% the variables ymin and ymax are defined as the minimum and
% maximum values repsectively of the data, to be used later, as the 
% pimits of the y axis for the time plot series

ymin=min(D)-0.2;
ymax=max(D)+0.2;

% obtain the start and stop times for the time series display of the ECG
% and plot the time series by setting the X-axis limits according to the
% unput values.

st_t = str2num(get(handles.start_t,'String'));
stop_t = str2num(get(handles.end_t,'String'));

% chose the axes to plot as the time series axes

axes(handles.timeaxes)

% plot the time series using a red line, and set the axis limits
% for y between ymin and ymax, and for the x-axis between st_t and stop_t

plot (H,'Color',[1 0 0]);
ylim([ymin ymax])
xlim([st_t stop_t])
set(handles.timeaxes, 'XColor', [0.51 0.51 1], 'YColor', [0.51 0.51 1])


% get the time delay from the difference between the two first measurements from
% the recorded data, by subtracting the two initial measurement times (Taf)
Taf = H(2,1) - H(1,1);

% the frequency is found by dividing 1 second over the Taf.
Freq = 1/Taf;

% the frequency, as well as the time delay value is displayed
% on the figure, by using the handles of the text boxes

str1 = sprintf('The signal has been sampled \nat %5.1f Hz.',Freq);
  set (handles.Sampling_f, 'String',str1);
str2 = sprintf('Delay \n(T = %5.4f sec)',Taf);
set (handles.delay_t, 'String',str2);


% the Callback function for the 2-D push button to perform the 2d state
% space plot

function varargout = ssplot2D_Callback(hObject, eventdata, handles, varargin)
% hObject    handle to ssplot3D (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

filename = get(handles.file_input, 'String');
H = xlsread(filename);

Taf = H(2,1) - H(1,1);

% the following if-else statements, check through the radio button handles(dt_1T-dt_100T),
% by checking the Value property of the radio buttons. 
% if the radio button is pressed Value is equal to 1
% for each delay button a value is assigned 'delay' that is used to indicate 
% the multiplier of the time delay  
Hli_1 = get(handles.dt_1T, 'Value');
if Hli_1 == 1;
   delay = 1;
else Hli_2 = get(handles.dt_2T, 'Value');
    if Hli_2 == 1;
       delay = 2;
    else Hli_3 = get(handles.dt_3T, 'Value');
        if Hli_3 == 1;
           delay = 3;
            else Hli_4 = get(handles.dt_4T, 'Value');
                if Hli_4 == 1;
                   delay = 4;
                    else Hli_5 = get(handles.dt_5T, 'Value');
                        if Hli_5 == 1;
                           delay = 5;
                         else Hli_6 = get(handles.dt_6T, 'Value');
                            if Hli_6 == 1;
                               delay = 6;
                                else Hli_7 = get(handles.dt_8T, 'Value');
                                    if Hli_7 == 1;
                                       delay = 8;
                                         else Hli_8 = get(handles.dt_10T, 'Value');
                                            if Hli_8 == 1;
                                               delay = 10;
                                                else Hli_9 = get(handles.dt_16T, 'Value');
                                                    if Hli_9 == 1;
                                                       delay = 16;
                                                        else Hli_10 = get(handles.dt_32T, 'Value');
                                                            if Hli_10 == 1;
                                                                delay = 32;                                                                
                                                            else Hli_11 = get(handles.dt_64T, 'Value');
                                                                if Hli_11 == 1;
                                                                    delay = 64;                                                                    
                                                                else Hli_12 = get(handles.dt_100T, 'Value');
                                                                    if Hli_12 == 1;
                                                                       delay = 100;
                                                                    end
                                                                 end
                                                             end
                                                      end
                                                                     
                                              end
                                     end
                            end
                   end
              end
         end
    end
end
    
% get the axes handle for the 2D state space representation 
                        axes(handles.ss2Daxes);
                        % variable D is assigned to the size of the array H
                        % variable D is a 1x2 array containing the number
                        % of data points in the first entry of the array
                        D = size(H);
                        K = D(1,1);
                        % the following steps create two arrays containing
                        % delayed versions of the original matrix H, to
                        % generate the state space plot
                        B = K - delay;
                        C = H(1:B,2);
                        start = delay + 1;
                        E = H(start:K,2);
                        % F is the delay coordinate matrix 
                        F = [C E];
                        % the elements of the first column of the array F
                        % are plotted against their delayed version in the
                        % second column
                        plot (F(:,1),F(:,2), 'Color', [0.984 0.788 0]);
                        set(handles.ss2Daxes, 'XColor', [0.51 0.51 1], 'YColor', [0.51 0.51 1])
                        axis square;
                        box on;
                        grid on;
                        


% --- Executes during object creation, after setting all properties.
function file_input_CreateFcn(hObject, eventdata, handles)
% hObject    handle to file_input (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function file_input_Callback(hObject, eventdata, handles)
% hObject    handle to file_input (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)



% --- Executes during object creation, after setting all properties.
function start_t_CreateFcn(hObject, eventdata, handles)
% hObject    handle to start_t (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function start_t_Callback(hObject, eventdata, handles)
% hObject    handle to start_t (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)



% the Callback function for the 3-D push button to perform the 3d state
% space plot

function ssplot3D_Callback(hObject, eventdata, handles)
% hObject    handle to ssplot3D (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% create new figure (figure 2)
figure (2)
set(gcf,'Color',[0 0 0.251])
filename = get(handles.file_input, 'String');
H = xlsread(filename);

Taf = H(2,1) - H(1,1);


Hli_1 = get(handles.dt_1T, 'Value');
if Hli_1 == 1;
     delay = 1;   
else Hli_2 = get(handles.dt_2T, 'Value');
    if Hli_2 == 1;
        delay = 2;        
    else Hli_3 = get(handles.dt_3T, 'Value');
        if Hli_3 == 1;
            delay = 3;            
            else Hli_4 = get(handles.dt_4T, 'Value');
                if Hli_4 == 1;
                     delay = 4;                   
                    else Hli_5 = get(handles.dt_5T, 'Value');
                        if Hli_5 == 1;
                         delay = 5;                         
                         else Hli_6 = get(handles.dt_6T, 'Value');
                            if Hli_6 == 1;
                                 delay = 6;                               
                                else Hli_7 = get(handles.dt_8T, 'Value');
                                    if Hli_7 == 1;
                                        delay = 8;                                        
                                         else Hli_8 = get(handles.dt_10T, 'Value');
                                            if Hli_8 == 1;
                                                delay = 10;                                                
                                                else Hli_9 = get(handles.dt_16T, 'Value');
                                                    if Hli_9 == 1;
                                                        delay = 16;                                                        
                                                        else Hli_10 = get(handles.dt_32T, 'Value');
                                                            if Hli_10 == 1;
                                                                delay = 32;                                                                
                                                                else Hli_11 = get(handles.dt_64T, 'Value');
                                                                if Hli_11 == 1;
                                                                    delay = 64;                                                                    
                                                                else Hli_12 = get(handles.dt_100T, 'Value');
                                                                    if Hli_12 == 1;
                                                                        delay = 100;                                                                        
                                                                    end
                                                                end
                                                            end
                                                     end
                                                                     
                                             end
                                     end
                             end
                     end
              end
         end
    end
end
    


    
                       % the process performed for the 3 dimensional state
                       % space representation is the same as that performed
                       % for the 2-d representation with the addition that
                       % instead of having two arrays, there are three
                       % delayed versions of the initial signal
                       
                        D = size(H);
                        K = D(1,1);
                       start = delay + 1;
                                                                     
                        G = 2*delay;
                        W = K - G;
                        P = H(1:W,2);
                        middle=K-delay;
                        Q = H(start:middle,2);
                        last=1+G;
                        R = H(last:K,2);
                       
                        % the 3d plot is plotted using the function plot3
                        
                        plot3(P,Q,R, 'Color', [0.984 0.788 0]);
                        set(gca, 'XColor', [0.51 0.51 1], 'YColor', [0.51 0.51 1], 'ZColor', [0.51 0.51 1])
                        axis square;
                        box on;
                        grid on;




% --- Executes during object creation, after setting all properties.
function R_start_CreateFcn(hObject, eventdata, handles)
% hObject    handle to R_start (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function R_start_Callback(hObject, eventdata, handles)
% hObject    handle to R_start (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of R_start as text
%        str2double(get(hObject,'String')) returns contents of R_start as a double


% --- Executes during object creation, after setting all properties.
function R_inc_CreateFcn(hObject, eventdata, handles)
% hObject    handle to R_inc (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function R_inc_Callback(hObject, eventdata, handles)
% hObject    handle to R_inc (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of R_inc as text
%        str2double(get(hObject,'String')) returns contents of R_inc as a double


% --- Executes during object creation, after setting all properties.
function R_end_CreateFcn(hObject, eventdata, handles)
% hObject    handle to R_end (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function R_end_Callback(hObject, eventdata, handles)
% hObject    handle to R_end (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% the Callback function for the D2 push button to perform the correlation
% dimension plot of logC(R) vs. log(R)

function varargout = cordim_plot_Callback(hObject, eventdata, handles, varargin)
% hObject    handle to cordim_plot (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Create new figure (figure 3)
figure (3)
set(gcf,'Color',[0 0 0.251])

% get the values specified in the edit boxes for the range of R values
rst=str2num(get(handles.R_start, 'String'));
rinc=str2num(get(handles.R_inc, 'String'));
rend=str2num(get(handles.R_end, 'String'));

% Generate R array according to the user specified values
R=(rst:rinc:rend);

filename = get(handles.file_input, 'String');
H = xlsread(filename);

D = size(H);
% W represents the number of data points contained in the signal file (n)
W = D(1,1);

% Get the value specified by the user for the embedding dimension m and
% associate it to the variable dim
dim = get(handles.emb_dim, 'Value');

Hli_1 = get(handles.dt_1T, 'Value');
if Hli_1 == 1;
    t = 1;   
else Hli_2 = get(handles.dt_2T, 'Value');
    if Hli_2 == 1;
        t = 2;       
    else Hli_3 = get(handles.dt_3T, 'Value');
        if Hli_3 == 1;
           t = 3;            
            else Hli_4 = get(handles.dt_4T, 'Value');
                if Hli_4 == 1;
                    t = 4;                   
                    else Hli_5 = get(handles.dt_5T, 'Value');
                        if Hli_5 == 1;
                           t = 5;                         
                         else Hli_6 = get(handles.dt_6T, 'Value');
                            if Hli_6 == 1;
                               t = 6;
                                else Hli_7 = get(handles.dt_8T, 'Value');
                                    if Hli_7 == 1;
                                       t = 8;
                                   else Hli_8 = get(handles.dt_10T, 'Value');
                                            if Hli_8 == 1;
                                               t = 10;
                                                else Hli_9 = get(handles.dt_16T, 'Value');
                                                    if Hli_9 == 1;
                                                       t = 16;                                                        
                                                        else Hli_10 = get(handles.dt_32T, 'Value');
                                                            if Hli_10 == 1;
                                                               t = 32;                                                                
                                                                else Hli_11 = get(handles.dt_64T, 'Value');
                                                                    if Hli_11 == 1;
                                                                       t = 64;                                                                        
                                                                     else Hli_12 = get(handles.dt_100T, 'Value');
                                                                        if Hli_12 == 1;
                                                                           t = 100;                                                                            
                                                                        end
                                                                 
                                                                    end
                                                             end
                                                     end
                                                                    
                                            end
                                    end
                            end
                    end
              end
         end
    end
end

% calculation of number of data points (N) used in the calculation, depending on the
% correlation dimension (dim) and the time delay (t)
N=W-(dim-1)*t;
B=H(:,2);
% Creation of matrix to be used for the embedding of the data in the
% m-dimensional space
% SS corresponds to trajectory
% linecol specifies an RGB vector specifyin the color of the line to be used for the
% plotting of logC(R) vs. log(R) for various embedding dimensions
if dim==1
   SS=[B(1:N)];
   linecol=[0.945 1 0.275];
elseif dim==2
    SS=[B(1:N),B(1+t:t+N)];
    linecol=[0.984 0.788 0];
elseif dim==3
    SS=[B(1:N),B(1+t:t+N),B(1+2*t:2*t+N)];
    linecol=[1 0.62 0.275];
elseif dim==4
    SS=[B(1:N),B(1+t:t+N),B(1+2*t:2*t+N),B(1+3*t:3*t+N)];
    linecol=[1 0.318 0.333];
elseif dim==5
    SS=[B(1:N),B(1+t:t+N),B(1+2*t:2*t+N),B(1+3*t:3*t+N),B(1+4*t:4*t+N)];
    linecol=[0.714 0.196 0.988];
elseif dim==6
    SS=[B(1:N),B(1+t:t+N),B(1+2*t:2*t+N),B(1+3*t:3*t+N),B(1+4*t:4*t+N),B(1+5*t:5*t+N)];
    linecol=[0.318 0.2 0.984];
elseif dim==7
    SS=[B(1:N),B(1+t:t+N),B(1+2*t:2*t+N),B(1+3*t:3*t+N),B(1+4*t:4*t+N),B(1+5*t:5*t+N),B(1+6*t:6*t+N)];
    linecol=[0.188 0.592 0.996];
elseif dim==8
    SS=[B(1:N),B(1+t:t+N),B(1+2*t:2*t+N),B(1+3*t:3*t+N),B(1+4*t:4*t+N),B(1+5*t:5*t+N),B(1+6*t:6*t+N),B(1+7*t:7*t+N)];
    linecol=[0.502 1 0.988];
elseif dim==9
    SS=[B(1:N),B(1+t:t+N),B(1+2*t:2*t+N),B(1+3*t:3*t+N),B(1+4*t:4*t+N),B(1+5*t:5*t+N),B(1+6*t:6*t+N),B(1+7*t:7*t+N),B(1+8*t:8*t+N)];
    linecol=[0.6 1 0.502];
elseif dim==10
    SS=[B(1:N),B(1+t:t+N),B(1+2*t:2*t+N),B(1+3*t:3*t+N),B(1+4*t:4*t+N),B(1+5*t:5*t+N),B(1+6*t:6*t+N),B(1+7*t:7*t+N),B(1+8*t:8*t+N),B(1+9*t:9*t+N)];
    linecol=[0 0.49 0.478];
end



% the main loop as defined in the algorithm development section 

z=size(R);
limit=z(1,2);
for k=2:limit
    corsum=0;
    dist=R(k);
   
    for p=1:N
        tpi=SS(p,:);
        
        for q=1:N            
            eucl=0;
            if q==p;
                q=q+1; 
            else tpj=SS(q,:);            
                if dim==1
                eucl=sqrt((tpi(1)-tpj(1))^2);
                    elseif dim==2
                eucl=sqrt(((tpi(1)-tpj(1))^2) + ((tpi(2)-tpj(2))^2));
                    elseif dim==3
                eucl=sqrt(((tpi(1)-tpj(1))^2) + ((tpi(2)-tpj(2))^2) + ((tpi(3)-tpj(3))^2));
                    elseif dim==4
                eucl=sqrt(((tpi(1)-tpj(1))^2) + ((tpi(2)-tpj(2))^2) + ((tpi(3)-tpj(3))^2) + ((tpi(4)-tpj(4))^2));
                    elseif dim==5
                eucl=sqrt(((tpi(1)-tpj(1))^2) + ((tpi(2)-tpj(2))^2) + ((tpi(3)-tpj(3))^2) + ((tpi(4)-tpj(4))^2) + ((tpi(5)-tpj(5))^2));
                    elseif dim==6
                eucl=sqrt(((tpi(1)-tpj(1))^2) + ((tpi(2)-tpj(2))^2) + ((tpi(3)-tpj(3))^2) + ((tpi(4)-tpj(4))^2) + ((tpi(5)-tpj(5))^2) + ((tpi(6)-tpj(6))^2));
                    elseif dim==7
                eucl=sqrt(((tpi(1)-tpj(1))^2) + ((tpi(2)-tpj(2))^2) + ((tpi(3)-tpj(3))^2) + ((tpi(4)-tpj(4))^2) + ((tpi(5)-tpj(5))^2) + ((tpi(6)-tpj(6))^2) + ((tpi(7)-tpj(7))^2));
                    elseif dim==8
                eucl=sqrt(((tpi(1)-tpj(1))^2) + ((tpi(2)-tpj(2))^2) + ((tpi(3)-tpj(3))^2) + ((tpi(4)-tpj(4))^2) + ((tpi(5)-tpj(5))^2) + ((tpi(6)-tpj(6))^2) + ((tpi(7)-tpj(7))^2) + ((tpi(8)-tpj(8))^2));
                    elseif dim==9
                eucl=sqrt(((tpi(1)-tpj(1))^2) + ((tpi(2)-tpj(2))^2) + ((tpi(3)-tpj(3))^2) + ((tpi(4)-tpj(4))^2) + ((tpi(5)-tpj(5))^2) + ((tpi(6)-tpj(6))^2) + ((tpi(7)-tpj(7))^2) + ((tpi(8)-tpj(8))^2) + ((tpi(9)-tpj(9))^2));
                    elseif dim==10
                eucl=sqrt(((tpi(1)-tpj(1))^2) + ((tpi(2)-tpj(2))^2) + ((tpi(3)-tpj(3))^2) + ((tpi(4)-tpj(4))^2) + ((tpi(5)-tpj(5))^2) + ((tpi(6)-tpj(6))^2) + ((tpi(7)-tpj(7))^2) + ((tpi(8)-tpj(8))^2) + ((tpi(9)-tpj(9))^2) + ((tpi(10)-tpj(10))^2));
                    end
                if eucl<=dist
                corsum=corsum+1;
                else 
                end  
            end
        end
            
    end 
    CR(k)=(1/(N*(N-1)))*corsum;
end

% The values obtained from the correlation sum calculation (DC and XAX) are set as
% global variables in order to be used by the edit boxes to estimate the
% correlation dimension
global DC
global XAX
DC=log(CR);
XAX=log(R);



region=XAX';
Scalreg = num2str(region);

% once the correlation sums have been calculated for the various values of
% R, the values for log R update the edit boxes used to specify the scaling
% region for the embedding dimension estimation

set(handles.ScalRegStart,'String',Scalreg)
set(handles.ScalRegEnd,'String',Scalreg)

set(gca, 'XColor', [0.51 0.51 1], 'YColor', [0.51 0.51 1],'NextPlot', 'add')
plot (XAX,DC,'Color',linecol,'LineWidth',1.0,'Marker','o','MarkerSize',2.0,'MarkerFaceColor','r');

                        axis square;
                        box on;
                        grid on;


% the following function Callbacks return the value of the radio button
% pressed, and make sure that no two radio buttons are pressed
% simultaneously
                        
% --- Executes on button press in dt_1T.
function varargout = dt_1T_Callback(hObject, eventdata, handles, varargin)
% hObject    handle to dt_1T (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

set (handles.dt_1T, 'Value',1);
set (handles.dt_2T, 'Value',0);
set (handles.dt_3T, 'Value',0);
set (handles.dt_4T, 'Value',0);
set (handles.dt_5T, 'Value',0);
set (handles.dt_6T, 'Value',0);
set (handles.dt_8T, 'Value',0);
set (handles.dt_10T, 'Value',0);
set (handles.dt_16T, 'Value',0);
set (handles.dt_32T, 'Value',0);
set (handles.dt_64T, 'Value',0);
set (handles.dt_100T, 'Value',0);

% --- Executes on button press in dt_2T.
function varargout = dt_2T_Callback(hObject, eventdata, handles, varargin)
% hObject    handle to dt_2T (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of dt_2T
set (handles.dt_1T, 'Value',0);
set (handles.dt_2T, 'Value',1);
set (handles.dt_3T, 'Value',0);
set (handles.dt_4T, 'Value',0);
set (handles.dt_5T, 'Value',0);
set (handles.dt_6T, 'Value',0);
set (handles.dt_8T, 'Value',0);
set (handles.dt_10T, 'Value',0);
set (handles.dt_16T, 'Value',0);
set (handles.dt_32T, 'Value',0);
set (handles.dt_64T, 'Value',0);
set (handles.dt_100T, 'Value',0);

% --- Executes on button press in dt_3T.
function varargout = dt_3T_Callback(hObject, eventdata, handles, varargin)
% hObject    handle to dt_3T (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of dt_3T

set (handles.dt_1T, 'Value',0);
set (handles.dt_2T, 'Value',0);
set (handles.dt_3T, 'Value',1);
set (handles.dt_4T, 'Value',0);
set (handles.dt_5T, 'Value',0);
set (handles.dt_6T, 'Value',0);
set (handles.dt_8T, 'Value',0);
set (handles.dt_10T, 'Value',0);
set (handles.dt_16T, 'Value',0);
set (handles.dt_32T, 'Value',0);
set (handles.dt_64T, 'Value',0);
set (handles.dt_100T, 'Value',0);

% --- Executes on button press in dt_4T.
function varargout = dt_4T_Callback(hObject, eventdata, handles, varargin)
% hObject    handle to dt_4T (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of dt_4T
set (handles.dt_1T, 'Value',0);
set (handles.dt_2T, 'Value',0);
set (handles.dt_3T, 'Value',0);
set (handles.dt_4T, 'Value',1);
set (handles.dt_5T, 'Value',0);
set (handles.dt_6T, 'Value',0);
set (handles.dt_8T, 'Value',0);
set (handles.dt_10T, 'Value',0);
set (handles.dt_16T, 'Value',0);
set (handles.dt_32T, 'Value',0);
set (handles.dt_64T, 'Value',0);
set (handles.dt_100T, 'Value',0);

% --- Executes on button press in dt_5T.
function varargout = dt_5T_Callback(hObject, eventdata, handles, varargin)
% hObject    handle to dt_5T (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of dt_5T
set (handles.dt_1T, 'Value',0);
set (handles.dt_2T, 'Value',0);
set (handles.dt_3T, 'Value',0);
set (handles.dt_4T, 'Value',0);
set (handles.dt_5T, 'Value',1);
set (handles.dt_6T, 'Value',0);
set (handles.dt_8T, 'Value',0);
set (handles.dt_10T, 'Value',0);
set (handles.dt_16T, 'Value',0);
set (handles.dt_32T, 'Value',0);
set (handles.dt_64T, 'Value',0);
set (handles.dt_100T, 'Value',0);

% --- Executes on button press in dt_6T.
function varargout = dt_6T_Callback(hObject, eventdata, handles, varargin)
% hObject    handle to dt_6T (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

set (handles.dt_1T, 'Value',0);
set (handles.dt_2T, 'Value',0);
set (handles.dt_3T, 'Value',0);
set (handles.dt_4T, 'Value',0);
set (handles.dt_5T, 'Value',0);
set (handles.dt_6T, 'Value',1);
set (handles.dt_8T, 'Value',0);
set (handles.dt_10T, 'Value',0);
set (handles.dt_16T, 'Value',0);
set (handles.dt_32T, 'Value',0);
set (handles.dt_64T, 'Value',0);
set (handles.dt_100T, 'Value',0);

% --- Executes on button press in dt_8T.
function varargout = dt_8T_Callback(hObject, eventdata, handles, varargin)
% hObject    handle to dt_8T (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

set (handles.dt_1T, 'Value',0);
set (handles.dt_2T, 'Value',0);
set (handles.dt_3T, 'Value',0);
set (handles.dt_4T, 'Value',0);
set (handles.dt_5T, 'Value',0);
set (handles.dt_6T, 'Value',0);
set (handles.dt_8T, 'Value',1);
set (handles.dt_10T, 'Value',0);
set (handles.dt_16T, 'Value',0);
set (handles.dt_32T, 'Value',0);
set (handles.dt_64T, 'Value',0);
set (handles.dt_100T, 'Value',0);

% --- Executes on button press in dt_10T.
function varargout = dt_10T_Callback(hObject, eventdata, handles, varargin)
% hObject    handle to dt_10T (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

set (handles.dt_1T, 'Value',0);
set (handles.dt_2T, 'Value',0);
set (handles.dt_3T, 'Value',0);
set (handles.dt_4T, 'Value',0);
set (handles.dt_5T, 'Value',0);
set (handles.dt_6T, 'Value',0);
set (handles.dt_8T, 'Value',0);
set (handles.dt_10T, 'Value',1);
set (handles.dt_16T, 'Value',0);
set (handles.dt_32T, 'Value',0);
set (handles.dt_64T, 'Value',0);
set (handles.dt_100T, 'Value',0);

% --- Executes on button press in dt_16T.
function varargout = dt_16T_Callback(hObject, eventdata, handles, varargin)
% hObject    handle to dt_16T (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

set (handles.dt_1T, 'Value',0);
set (handles.dt_2T, 'Value',0);
set (handles.dt_3T, 'Value',0);
set (handles.dt_4T, 'Value',0);
set (handles.dt_5T, 'Value',0);
set (handles.dt_6T, 'Value',0);
set (handles.dt_8T, 'Value',0);
set (handles.dt_10T, 'Value',0);
set (handles.dt_16T, 'Value',1);
set (handles.dt_32T, 'Value',0);
set (handles.dt_64T, 'Value',0);
set (handles.dt_100T, 'Value',0);

% --- Executes on button press in dt_32T.
function varargout = dt_32T_Callback(hObject, eventdata, handles, varargin)
% hObject    handle to dt_32T (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

set (handles.dt_1T, 'Value',0);
set (handles.dt_2T, 'Value',0);
set (handles.dt_3T, 'Value',0);
set (handles.dt_4T, 'Value',0);
set (handles.dt_5T, 'Value',0);
set (handles.dt_6T, 'Value',0);
set (handles.dt_8T, 'Value',0);
set (handles.dt_10T, 'Value',0);
set (handles.dt_16T, 'Value',0);
set (handles.dt_32T, 'Value',1);
set (handles.dt_64T, 'Value',0);
set (handles.dt_100T, 'Value',0);

% --- Executes on button press in dt_64T.
function dt_64T_Callback(hObject, eventdata, handles)
% hObject    handle to dt_64T (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

set (handles.dt_1T, 'Value',0);
set (handles.dt_2T, 'Value',0);
set (handles.dt_3T, 'Value',0);
set (handles.dt_4T, 'Value',0);
set (handles.dt_5T, 'Value',0);
set (handles.dt_6T, 'Value',0);
set (handles.dt_8T, 'Value',0);
set (handles.dt_10T, 'Value',0);
set (handles.dt_16T, 'Value',0);
set (handles.dt_32T, 'Value',0);
set (handles.dt_64T, 'Value',1);
set (handles.dt_100T, 'Value',0);

% --- Executes on button press in dt_100T.
function dt_100T_Callback(hObject, eventdata, handles)
% hObject    handle to dt_100T (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

set (handles.dt_1T, 'Value',0);
set (handles.dt_2T, 'Value',0);
set (handles.dt_3T, 'Value',0);
set (handles.dt_4T, 'Value',0);
set (handles.dt_5T, 'Value',0);
set (handles.dt_6T, 'Value',0);
set (handles.dt_8T, 'Value',0);
set (handles.dt_10T, 'Value',0);
set (handles.dt_16T, 'Value',0);
set (handles.dt_32T, 'Value',0);
set (handles.dt_64T, 'Value',0);
set (handles.dt_100T, 'Value',1);

% --- Executes during object creation, after setting all properties.
function emb_dim_CreateFcn(hObject, eventdata, handles)
% hObject    handle to emb_dim (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on selection change in emb_dim.
function emb_dim_Callback(hObject, eventdata, handles)
% hObject    handle to emb_dim (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes during object creation, after setting all properties.
function ScalRegStart_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ScalRegStart (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on selection change in ScalRegStart.
function ScalRegStart_Callback(hObject, eventdata, handles)
% hObject    handle to ScalRegStart (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes during object creation, after setting all properties.
function ScalRegEnd_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ScalRegend (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end

% this function calculates the embedding dimension according to the scaling
% region specified in the edit boxes and is activated by pressing the
% final value for the scaling region in the edit box

% --- Executes on selection change in ScalRegend.
function ScalRegEnd_Callback(hObject, eventdata, handles)
% hObject    handle to ScalRegend (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

global DC
global XAX

region=XAX';
Scalreg = num2str(region);

set(handles.ScalRegStart,'String',Scalreg)
set(handles.ScalRegEnd,'String',Scalreg)

% the way the correlation dimension is estimated is by calculating the plot
% of the line specified by the user defined values for the scaling region
% in terms of log(R), and their corresponding values of logC(R)

srst=get(handles.ScalRegStart,'Value');
srend = get(handles.ScalRegEnd,'Value');

CorDim=(DC(srend)-DC(srst))/(XAX(srend)-XAX(srst));

% finally the correlation dimension is displayed in the embedding dimension
% text box, by appropriate use of its handle

cordimstr=sprintf('Correlation dimension\nD2 = %4.3f',CorDim);
set(handles.cordimD2,'String',cordimstr);





